package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodegenFeatureFlags(
    isRelationshipSupported: Optional[Boolean] = Optional.Absent,
    isNonModelSupported: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags = {
    import CodegenFeatureFlags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags
      .builder()
      .optionallyWith(
        isRelationshipSupported.map(value => value: java.lang.Boolean)
      )(_.isRelationshipSupported)
      .optionallyWith(
        isNonModelSupported.map(value => value: java.lang.Boolean)
      )(_.isNonModelSupported)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.wrap(buildAwsValue())
}
object CodegenFeatureFlags {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenFeatureFlags =
      zio.aws.amplifyuibuilder.model.CodegenFeatureFlags(
        isRelationshipSupported.map(value => value),
        isNonModelSupported.map(value => value)
      )
    def isRelationshipSupported: Optional[Boolean]
    def isNonModelSupported: Optional[Boolean]
    def getIsRelationshipSupported: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("isRelationshipSupported", isRelationshipSupported)
    def getIsNonModelSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isNonModelSupported", isNonModelSupported)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags
  ) extends zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly {
    override val isRelationshipSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isRelationshipSupported())
        .map(value => value: Boolean)
    override val isNonModelSupported: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNonModelSupported())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags
  ): zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly = new Wrapper(
    impl
  )
}
