package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartCodegenJobData(
    renderConfig: zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig,
    genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema
    ] = Optional.Absent,
    autoGenerateForms: Optional[Boolean] = Optional.Absent,
    features: Optional[zio.aws.amplifyuibuilder.model.CodegenFeatureFlags] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobData = {
    import StartCodegenJobData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobData
      .builder()
      .renderConfig(renderConfig.buildAwsValue())
      .optionallyWith(genericDataSchema.map(value => value.buildAwsValue()))(
        _.genericDataSchema
      )
      .optionallyWith(autoGenerateForms.map(value => value: java.lang.Boolean))(
        _.autoGenerateForms
      )
      .optionallyWith(features.map(value => value.buildAwsValue()))(_.features)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly =
    zio.aws.amplifyuibuilder.model.StartCodegenJobData.wrap(buildAwsValue())
}
object StartCodegenJobData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.StartCodegenJobData =
      zio.aws.amplifyuibuilder.model.StartCodegenJobData(
        renderConfig.asEditable,
        genericDataSchema.map(value => value.asEditable),
        autoGenerateForms.map(value => value),
        features.map(value => value.asEditable),
        tags.map(value => value)
      )
    def renderConfig
        : zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly
    def genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ]
    def autoGenerateForms: Optional[Boolean]
    def features
        : Optional[zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getRenderConfig: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly
    ] = ZIO.succeed(renderConfig)
    def getGenericDataSchema: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ] = AwsError.unwrapOptionField("genericDataSchema", genericDataSchema)
    def getAutoGenerateForms: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGenerateForms", autoGenerateForms)
    def getFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly
    ] = AwsError.unwrapOptionField("features", features)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobData
  ) extends zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly {
    override val renderConfig
        : zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig
        .wrap(impl.renderConfig())
    override val genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.genericDataSchema())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.wrap(value)
      )
    override val autoGenerateForms: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGenerateForms())
      .map(value => value: Boolean)
    override val features: Optional[
      zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.features())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobData
  ): zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly = new Wrapper(
    impl
  )
}
