package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GraphQLRenderConfig(
    typesFilePath: String,
    queriesFilePath: String,
    mutationsFilePath: String,
    subscriptionsFilePath: String,
    fragmentsFilePath: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig = {
    import GraphQLRenderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig
      .builder()
      .typesFilePath(typesFilePath: java.lang.String)
      .queriesFilePath(queriesFilePath: java.lang.String)
      .mutationsFilePath(mutationsFilePath: java.lang.String)
      .subscriptionsFilePath(subscriptionsFilePath: java.lang.String)
      .fragmentsFilePath(fragmentsFilePath: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.wrap(buildAwsValue())
}
object GraphQLRenderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GraphQLRenderConfig =
      zio.aws.amplifyuibuilder.model.GraphQLRenderConfig(
        typesFilePath,
        queriesFilePath,
        mutationsFilePath,
        subscriptionsFilePath,
        fragmentsFilePath
      )
    def typesFilePath: String
    def queriesFilePath: String
    def mutationsFilePath: String
    def subscriptionsFilePath: String
    def fragmentsFilePath: String
    def getTypesFilePath: ZIO[Any, Nothing, String] = ZIO.succeed(typesFilePath)
    def getQueriesFilePath: ZIO[Any, Nothing, String] =
      ZIO.succeed(queriesFilePath)
    def getMutationsFilePath: ZIO[Any, Nothing, String] =
      ZIO.succeed(mutationsFilePath)
    def getSubscriptionsFilePath: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionsFilePath)
    def getFragmentsFilePath: ZIO[Any, Nothing, String] =
      ZIO.succeed(fragmentsFilePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig
  ) extends zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly {
    override val typesFilePath: String = impl.typesFilePath(): String
    override val queriesFilePath: String = impl.queriesFilePath(): String
    override val mutationsFilePath: String = impl.mutationsFilePath(): String
    override val subscriptionsFilePath: String =
      impl.subscriptionsFilePath(): String
    override val fragmentsFilePath: String = impl.fragmentsFilePath(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig
  ): zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly = new Wrapper(
    impl
  )
}
