package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters.*
sealed trait CodegenJobStatus {
  def unwrap
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus
}
object CodegenJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus
  ): zio.aws.amplifyuibuilder.model.CodegenJobStatus = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.IN_PROGRESS =>
      val r = in_progress
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.SUCCEEDED =>
      val r = succeeded
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.CodegenJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object in_progress
      extends zio.aws.amplifyuibuilder.model.CodegenJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.IN_PROGRESS
  }
  case object failed extends zio.aws.amplifyuibuilder.model.CodegenJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.FAILED
  }
  case object succeeded
      extends zio.aws.amplifyuibuilder.model.CodegenJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus =
      software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus.SUCCEEDED
  }
}
