package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodegenDependency(
    name: Optional[String] = Optional.Absent,
    supportedVersion: Optional[String] = Optional.Absent,
    isSemVer: Optional[Boolean] = Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency = {
    import CodegenDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(supportedVersion.map(value => value: java.lang.String))(
        _.supportedVersion
      )
      .optionallyWith(isSemVer.map(value => value: java.lang.Boolean))(
        _.isSemVer
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CodegenDependency.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenDependency.wrap(buildAwsValue())
}
object CodegenDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenDependency =
      zio.aws.amplifyuibuilder.model.CodegenDependency(
        name.map(value => value),
        supportedVersion.map(value => value),
        isSemVer.map(value => value),
        reason.map(value => value)
      )
    def name: Optional[String]
    def supportedVersion: Optional[String]
    def isSemVer: Optional[Boolean]
    def reason: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSupportedVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportedVersion", supportedVersion)
    def getIsSemVer: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSemVer", isSemVer)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency
  ) extends zio.aws.amplifyuibuilder.model.CodegenDependency.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val supportedVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedVersion())
      .map(value => value: String)
    override val isSemVer: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSemVer())
      .map(value => value: Boolean)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency
  ): zio.aws.amplifyuibuilder.model.CodegenDependency.ReadOnly = new Wrapper(
    impl
  )
}
