package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters.*
sealed trait JSModule {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.JSModule
}
object JSModule {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.JSModule
  ): zio.aws.amplifyuibuilder.model.JSModule = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.ES2020 =>
      val r = es2020
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.ESNEXT =>
      val r = esnext
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.JSModule {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSModule =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.UNKNOWN_TO_SDK_VERSION
  }
  case object es2020 extends zio.aws.amplifyuibuilder.model.JSModule {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSModule =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.ES2020
  }
  case object esnext extends zio.aws.amplifyuibuilder.model.JSModule {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSModule =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSModule.ESNEXT
  }
}
