package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{ThemeName, Uuid}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateThemeData(
    id: Optional[Uuid] = Optional.Absent,
    name: Optional[ThemeName] = Optional.Absent,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues],
    overrides: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData = {
    import UpdateThemeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
      .builder()
      .optionallyWith(id.map(value => Uuid.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ThemeName.unwrap(value): java.lang.String)
      )(_.name)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateThemeData.wrap(buildAwsValue())
}
object UpdateThemeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateThemeData =
      zio.aws.amplifyuibuilder.model.UpdateThemeData(
        id.map(value => value),
        name.map(value => value),
        values.map { item =>
          item.asEditable
        },
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[Uuid]
    def name: Optional[ThemeName]
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def getId: ZIO[Any, AwsError, Uuid] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ThemeName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ) extends zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly {
    override val id: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.Uuid(value))
    override val name: Optional[ThemeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.ThemeName(value))
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
    override val overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ): zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly = new Wrapper(impl)
}
