package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey, FormName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFormData(
    name: FormName,
    dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig,
    formActionType: zio.aws.amplifyuibuilder.model.FormActionType,
    fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig],
    style: zio.aws.amplifyuibuilder.model.FormStyle,
    sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement
    ],
    schemaVersion: String,
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData = {
    import CreateFormData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
      .builder()
      .name(FormName.unwrap(name): java.lang.String)
      .dataType(dataType.buildAwsValue())
      .formActionType(formActionType.unwrap)
      .fields(
        fields
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .style(style.buildAwsValue())
      .sectionalElements(
        sectionalElements
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .schemaVersion(schemaVersion: java.lang.String)
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(labelDecorator.map(value => value.unwrap))(
        _.labelDecorator
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateFormData.wrap(buildAwsValue())
}
object CreateFormData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateFormData =
      zio.aws.amplifyuibuilder.model.CreateFormData(
        name,
        dataType.asEditable,
        formActionType,
        fields.map({ case (key, value) =>
          key -> value.asEditable
        }),
        style.asEditable,
        sectionalElements.map({ case (key, value) =>
          key -> value.asEditable
        }),
        schemaVersion,
        cta.map(value => value.asEditable),
        tags.map(value => value),
        labelDecorator.map(value => value)
      )
    def name: FormName
    def dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    def formActionType: zio.aws.amplifyuibuilder.model.FormActionType
    def fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    def style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    def sectionalElements
        : Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    def schemaVersion: String
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator]
    def getName: ZIO[Any, Nothing, FormName] = ZIO.succeed(name)
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = ZIO.succeed(dataType)
    def getFormActionType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormActionType] =
      ZIO.succeed(formActionType)
    def getFields: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = ZIO.succeed(fields)
    def getStyle
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      ZIO.succeed(style)
    def getSectionalElements: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = ZIO.succeed(sectionalElements)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLabelDecorator
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.LabelDecorator] =
      AwsError.unwrapOptionField("labelDecorator", labelDecorator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ) extends zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly {
    override val name: FormName =
      zio.aws.amplifyuibuilder.model.primitives.FormName(impl.name())
    override val dataType
        : zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(impl.dataType())
    override val formActionType: zio.aws.amplifyuibuilder.model.FormActionType =
      zio.aws.amplifyuibuilder.model.FormActionType.wrap(impl.formActionType())
    override val fields
        : Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly] =
      impl
        .fields()
        .asScala
        .map({ case (key, value) =>
          (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
            .wrap(value)
        })
        .toMap
    override val style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormStyle.wrap(impl.style())
    override val sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ] = impl
      .sectionalElements()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
          .wrap(value)
      })
      .toMap
    override val schemaVersion: String = impl.schemaVersion(): String
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val labelDecorator
        : Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDecorator())
        .map(value => zio.aws.amplifyuibuilder.model.LabelDecorator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ): zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly = new Wrapper(impl)
}
