package zio.aws.amplifyuibuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentName,
  SyntheticTimestamp_date_time,
  TagValue,
  Uuid,
  ComponentType,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Component(
    appId: String,
    environmentName: String,
    sourceId: Optional[String] = Optional.Absent,
    id: Uuid,
    name: ComponentName,
    componentType: ComponentType,
    properties: Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty],
    children: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]
    ] = Optional.Absent,
    variants: Iterable[zio.aws.amplifyuibuilder.model.ComponentVariant],
    overrides: Map[String, Map[String, String]],
    bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
    ],
    collectionProperties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
    ] = Optional.Absent,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent]
    ] = Optional.Absent,
    schemaVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Component = {
    import Component.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Component
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .id(Uuid.unwrap(id): java.lang.String)
      .name(ComponentName.unwrap(name): java.lang.String)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .properties(
        properties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .variants(variants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .overrides(
        overrides
          .map({ case (key, value) =>
            (key: java.lang.String) -> value
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          })
          .asJava
      )
      .bindingProperties(
        bindingProperties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        collectionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.collectionProperties)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        events.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.events)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Component.ReadOnly =
    zio.aws.amplifyuibuilder.model.Component.wrap(buildAwsValue())
}
object Component {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Component =
      zio.aws.amplifyuibuilder.model.Component(
        appId,
        environmentName,
        sourceId.map(value => value),
        id,
        name,
        componentType,
        properties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        variants.map { item =>
          item.asEditable
        },
        overrides,
        bindingProperties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        collectionProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        createdAt,
        modifiedAt.map(value => value),
        tags.map(value => value),
        events.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        schemaVersion.map(value => value)
      )
    def appId: String
    def environmentName: String
    def sourceId: Optional[String]
    def id: Uuid
    def name: ComponentName
    def componentType: ComponentType
    def properties
        : Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def children
        : Optional[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def variants: List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    def overrides: Map[String, Map[String, String]]
    def bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]
    def collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]]
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: Optional[SyntheticTimestamp_date_time]
    def tags: Optional[Map[TagKey, TagValue]]
    def events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ]
    def schemaVersion: Optional[String]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ComponentName] = ZIO.succeed(name)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
    def getProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = ZIO.succeed(properties)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getVariants: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly
    ]] = ZIO.succeed(variants)
    def getOverrides: ZIO[Any, Nothing, Map[String, Map[String, String]]] =
      ZIO.succeed(overrides)
    def getBindingProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = ZIO.succeed(bindingProperties)
    def getCollectionProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("collectionProperties", collectionProperties)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEvents: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ) extends zio.aws.amplifyuibuilder.model.Component.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val sourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => value: String)
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName(impl.name())
    override val componentType: ComponentType =
      zio.aws.amplifyuibuilder.model.primitives
        .ComponentType(impl.componentType())
    override val properties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = impl
      .properties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
          .wrap(value)
      })
      .toMap
    override val children: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.children())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
        }.toList
      )
    override val variants
        : List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly] = impl
      .variants()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(item)
      }
      .toList
    override val overrides: Map[String, Map[String, String]] = impl
      .overrides()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      })
      .toMap
    override val bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ] = impl
      .bindingProperties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
          .wrap(value)
      })
      .toMap
    override val collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentEvent
              .wrap(value)
          })
          .toMap
      )
    override val schemaVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ): zio.aws.amplifyuibuilder.model.Component.ReadOnly = new Wrapper(impl)
}
