package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FormStyle(
    horizontalGap: Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig] =
      Optional.Absent,
    verticalGap: Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig] =
      Optional.Absent,
    outerPadding: Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle = {
    import FormStyle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle
      .builder()
      .optionallyWith(horizontalGap.map(value => value.buildAwsValue()))(
        _.horizontalGap
      )
      .optionallyWith(verticalGap.map(value => value.buildAwsValue()))(
        _.verticalGap
      )
      .optionallyWith(outerPadding.map(value => value.buildAwsValue()))(
        _.outerPadding
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormStyle.wrap(buildAwsValue())
}
object FormStyle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormStyle =
      zio.aws.amplifyuibuilder.model.FormStyle(
        horizontalGap.map(value => value.asEditable),
        verticalGap.map(value => value.asEditable),
        outerPadding.map(value => value.asEditable)
      )
    def horizontalGap
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly]
    def verticalGap
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly]
    def outerPadding
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly]
    def getHorizontalGap: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly
    ] = AwsError.unwrapOptionField("horizontalGap", horizontalGap)
    def getVerticalGap: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly
    ] = AwsError.unwrapOptionField("verticalGap", verticalGap)
    def getOuterPadding: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outerPadding", outerPadding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle
  ) extends zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly {
    override val horizontalGap
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.horizontalGap())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormStyleConfig.wrap(value)
        )
    override val verticalGap
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verticalGap())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormStyleConfig.wrap(value)
        )
    override val outerPadding
        : Optional[zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outerPadding())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormStyleConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormStyle
  ): zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly = new Wrapper(impl)
}
