package zio.aws.amplifyuibuilder
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey, Integer}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.amplifyuibuilder.model.primitives.OperandType.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ComponentName extends Subtype[String]
    type ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName.Type
    object ComponentType extends Subtype[String]
    type ComponentType =
      zio.aws.amplifyuibuilder.model.primitives.ComponentType.Type
    object FormName extends Subtype[String]
    type FormName = zio.aws.amplifyuibuilder.model.primitives.FormName.Type
    type Integer = Int
    object ListComponentsLimit extends Subtype[Int]
    type ListComponentsLimit =
      zio.aws.amplifyuibuilder.model.primitives.ListComponentsLimit.Type
    object ListFormsLimit extends Subtype[Int]
    type ListFormsLimit =
      zio.aws.amplifyuibuilder.model.primitives.ListFormsLimit.Type
    object ListThemesLimit extends Subtype[Int]
    type ListThemesLimit =
      zio.aws.amplifyuibuilder.model.primitives.ListThemesLimit.Type
    object OperandType extends Subtype[String]
    type OperandType =
      zio.aws.amplifyuibuilder.model.primitives.OperandType.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.amplifyuibuilder.model.primitives.SensitiveString.Type
    object SyntheticTimestamp_date_time extends Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.amplifyuibuilder.model.primitives.SyntheticTimestamp_date_time.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.amplifyuibuilder.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.amplifyuibuilder.model.primitives.TagValue.Type
    object ThemeName extends Subtype[String]
    type ThemeName = zio.aws.amplifyuibuilder.model.primitives.ThemeName.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.amplifyuibuilder.model.primitives.Uuid.Type
  }
  type ComponentBindingProperties =
    Map[String, zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue]
  type ComponentChildList = List[zio.aws.amplifyuibuilder.model.ComponentChild]
  type ComponentCollectionProperties =
    Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
  type ComponentEvents =
    Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent]
  type ComponentList = List[zio.aws.amplifyuibuilder.model.Component]
  type ComponentOverrides = Map[String, Map[String, String]]
  type ComponentOverridesValue = Map[String, String]
  type ComponentProperties =
    Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty]
  type ComponentPropertyList =
    List[zio.aws.amplifyuibuilder.model.ComponentProperty]
  type ComponentSummaryList =
    List[zio.aws.amplifyuibuilder.model.ComponentSummary]
  type ComponentVariantValues = Map[String, String]
  type ComponentVariants = List[zio.aws.amplifyuibuilder.model.ComponentVariant]
  type FeaturesMap = Map[String, String]
  type FieldsMap = Map[String, zio.aws.amplifyuibuilder.model.FieldConfig]
  type FormBindings =
    Map[String, zio.aws.amplifyuibuilder.model.FormBindingElement]
  type FormInputBindingProperties =
    Map[String, zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue]
  type FormInputValuePropertyList =
    List[zio.aws.amplifyuibuilder.model.FormInputValueProperty]
  type FormList = List[zio.aws.amplifyuibuilder.model.Form]
  type FormSummaryList = List[zio.aws.amplifyuibuilder.model.FormSummary]
  type IdentifierList = List[String]
  type NumValues = List[Integer]
  type PredicateList = List[zio.aws.amplifyuibuilder.model.Predicate]
  type SectionalElementMap =
    Map[String, zio.aws.amplifyuibuilder.model.SectionalElement]
  type SortPropertyList = List[zio.aws.amplifyuibuilder.model.SortProperty]
  type StrValues = List[String]
  type Tags = Map[TagKey, TagValue]
  type ThemeList = List[zio.aws.amplifyuibuilder.model.Theme]
  type ThemeSummaryList = List[zio.aws.amplifyuibuilder.model.ThemeSummary]
  type ThemeValuesList = List[zio.aws.amplifyuibuilder.model.ThemeValues]
  type ValidationsList =
    List[zio.aws.amplifyuibuilder.model.FieldValidationConfiguration]
  type ValueMappingList = List[zio.aws.amplifyuibuilder.model.ValueMapping]
}
