package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SortProperty(
    field: String,
    direction: zio.aws.amplifyuibuilder.model.SortDirection
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty = {
    import SortProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty
      .builder()
      .field(field: java.lang.String)
      .direction(direction.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.SortProperty.wrap(buildAwsValue())
}
object SortProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.SortProperty =
      zio.aws.amplifyuibuilder.model.SortProperty(field, direction)
    def field: String
    def direction: zio.aws.amplifyuibuilder.model.SortDirection
    def getField: ZIO[Any, Nothing, String] = ZIO.succeed(field)
    def getDirection
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.SortDirection] =
      ZIO.succeed(direction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty
  ) extends zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly {
    override val field: String = impl.field(): String
    override val direction: zio.aws.amplifyuibuilder.model.SortDirection =
      zio.aws.amplifyuibuilder.model.SortDirection.wrap(impl.direction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty
  ): zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly = new Wrapper(impl)
}
