package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.FormName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFormData(
    name: Optional[FormName] = Optional.Absent,
    dataType: Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig] =
      Optional.Absent,
    formActionType: Optional[zio.aws.amplifyuibuilder.model.FormActionType] =
      Optional.Absent,
    fields: Optional[Map[String, zio.aws.amplifyuibuilder.model.FieldConfig]] =
      Optional.Absent,
    style: Optional[zio.aws.amplifyuibuilder.model.FormStyle] = Optional.Absent,
    sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement]
    ] = Optional.Absent,
    schemaVersion: Optional[String] = Optional.Absent,
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData = {
    import UpdateFormData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
      .builder()
      .optionallyWith(
        name.map(value => FormName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(dataType.map(value => value.buildAwsValue()))(_.dataType)
      .optionallyWith(formActionType.map(value => value.unwrap))(
        _.formActionType
      )
      .optionallyWith(
        fields.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.fields)
      .optionallyWith(style.map(value => value.buildAwsValue()))(_.style)
      .optionallyWith(
        sectionalElements.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.sectionalElements)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .optionallyWith(labelDecorator.map(value => value.unwrap))(
        _.labelDecorator
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateFormData.wrap(buildAwsValue())
}
object UpdateFormData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateFormData =
      zio.aws.amplifyuibuilder.model.UpdateFormData(
        name.map(value => value),
        dataType.map(value => value.asEditable),
        formActionType.map(value => value),
        fields.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        style.map(value => value.asEditable),
        sectionalElements.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        schemaVersion.map(value => value),
        cta.map(value => value.asEditable),
        labelDecorator.map(value => value)
      )
    def name: Optional[FormName]
    def dataType
        : Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly]
    def formActionType: Optional[zio.aws.amplifyuibuilder.model.FormActionType]
    def fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    ]
    def style: Optional[zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly]
    def sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    ]
    def schemaVersion: Optional[String]
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def labelDecorator: Optional[zio.aws.amplifyuibuilder.model.LabelDecorator]
    def getName: ZIO[Any, AwsError, FormName] =
      AwsError.unwrapOptionField("name", name)
    def getDataType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataType", dataType)
    def getFormActionType
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormActionType] =
      AwsError.unwrapOptionField("formActionType", formActionType)
    def getFields: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
    def getStyle: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    ] = AwsError.unwrapOptionField("style", style)
    def getSectionalElements: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = AwsError.unwrapOptionField("sectionalElements", sectionalElements)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getLabelDecorator
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.LabelDecorator] =
      AwsError.unwrapOptionField("labelDecorator", labelDecorator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ) extends zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly {
    override val name: Optional[FormName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.FormName(value))
    override val dataType
        : Optional[zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(value)
        )
    override val formActionType
        : Optional[zio.aws.amplifyuibuilder.model.FormActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formActionType())
        .map(value => zio.aws.amplifyuibuilder.model.FormActionType.wrap(value))
    override val fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
              .wrap(value)
          })
          .toMap
      )
    override val style
        : Optional[zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.style())
        .map(value => zio.aws.amplifyuibuilder.model.FormStyle.wrap(value))
    override val sectionalElements: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sectionalElements())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
              .wrap(value)
          })
          .toMap
      )
    override val schemaVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: String)
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val labelDecorator
        : Optional[zio.aws.amplifyuibuilder.model.LabelDecorator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDecorator())
        .map(value => zio.aws.amplifyuibuilder.model.LabelDecorator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormData
  ): zio.aws.amplifyuibuilder.model.UpdateFormData.ReadOnly = new Wrapper(impl)
}
