package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentBindingPropertiesValue(
    `type`: Optional[String] = Optional.Absent,
    bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
    ] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue = {
    import ComponentBindingPropertiesValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
      .builder()
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(bindingProperties.map(value => value.buildAwsValue()))(
        _.bindingProperties
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
      .wrap(buildAwsValue())
}
object ComponentBindingPropertiesValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue =
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue(
        `type`.map(value => value),
        bindingProperties.map(value => value.asEditable),
        defaultValue.map(value => value)
      )
    def `type`: Optional[String]
    def bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ]
    def defaultValue: Optional[String]
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ) extends zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly {
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValueProperties
          .wrap(value)
      )
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue
  ): zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly =
    new Wrapper(impl)
}
