package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FormButton(
    excluded: Optional[Boolean] = Optional.Absent,
    children: Optional[String] = Optional.Absent,
    position: Optional[zio.aws.amplifyuibuilder.model.FieldPosition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormButton = {
    import FormButton.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormButton
      .builder()
      .optionallyWith(excluded.map(value => value: java.lang.Boolean))(
        _.excluded
      )
      .optionallyWith(children.map(value => value: java.lang.String))(
        _.children
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormButton.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormButton.wrap(buildAwsValue())
}
object FormButton {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormButton
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormButton =
      zio.aws.amplifyuibuilder.model.FormButton(
        excluded.map(value => value),
        children.map(value => value),
        position.map(value => value.asEditable)
      )
    def excluded: Optional[Boolean]
    def children: Optional[String]
    def position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly]
    def getExcluded: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excluded", excluded)
    def getChildren: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("children", children)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormButton
  ) extends zio.aws.amplifyuibuilder.model.FormButton.ReadOnly {
    override val excluded: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.excluded())
      .map(value => value: Boolean)
    override val children: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.children())
      .map(value => value: String)
    override val position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.amplifyuibuilder.model.FieldPosition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormButton
  ): zio.aws.amplifyuibuilder.model.FormButton.ReadOnly = new Wrapper(impl)
}
