package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{Integer, SensitiveString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExchangeCodeForTokenResponse(
    accessToken: SensitiveString,
    expiresIn: Integer,
    refreshToken: SensitiveString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse = {
    import ExchangeCodeForTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
      .builder()
      .accessToken(SensitiveString.unwrap(accessToken): java.lang.String)
      .expiresIn(expiresIn: java.lang.Integer)
      .refreshToken(SensitiveString.unwrap(refreshToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse
      .wrap(buildAwsValue())
}
object ExchangeCodeForTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse =
      zio.aws.amplifyuibuilder.model
        .ExchangeCodeForTokenResponse(accessToken, expiresIn, refreshToken)
    def accessToken: SensitiveString
    def expiresIn: Integer
    def refreshToken: SensitiveString
    def getAccessToken: ZIO[Any, Nothing, SensitiveString] =
      ZIO.succeed(accessToken)
    def getExpiresIn: ZIO[Any, Nothing, Integer] = ZIO.succeed(expiresIn)
    def getRefreshToken: ZIO[Any, Nothing, SensitiveString] =
      ZIO.succeed(refreshToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ) extends zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly {
    override val accessToken: SensitiveString =
      zio.aws.amplifyuibuilder.model.primitives
        .SensitiveString(impl.accessToken())
    override val expiresIn: Integer = impl.expiresIn(): Integer
    override val refreshToken: SensitiveString =
      zio.aws.amplifyuibuilder.model.primitives
        .SensitiveString(impl.refreshToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
  ): zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly =
    new Wrapper(impl)
}
