package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentConditionProperty(
    property: Optional[String] = Optional.Absent,
    field: Optional[String] = Optional.Absent,
    operator: Optional[String] = Optional.Absent,
    operand: Optional[String] = Optional.Absent,
    `then`: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    elseValue: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    operandType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty = {
    import ComponentConditionProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
      .builder()
      .optionallyWith(property.map(value => value: java.lang.String))(
        _.property
      )
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(operand.map(value => value: java.lang.String))(_.operand)
      .optionallyWith(`then`.map(value => value.buildAwsValue()))(_.`then`)
      .optionallyWith(elseValue.map(value => value.buildAwsValue()))(
        _.elseValue
      )
      .optionallyWith(operandType.map(value => value: java.lang.String))(
        _.operandType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentConditionProperty
      .wrap(buildAwsValue())
}
object ComponentConditionProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentConditionProperty =
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty(
        property.map(value => value),
        field.map(value => value),
        operator.map(value => value),
        operand.map(value => value),
        `then`.map(value => value.asEditable),
        elseValue.map(value => value.asEditable),
        operandType.map(value => value)
      )
    def property: Optional[String]
    def field: Optional[String]
    def operator: Optional[String]
    def operand: Optional[String]
    def `then`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def elseValue
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def operandType: Optional[String]
    def getProperty: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("property", property)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getOperand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operand", operand)
    def getThen: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("then", `then`)
    def getElseValue: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("elseValue", elseValue)
    def getOperandType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operandType", operandType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ) extends zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly {
    override val property: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.property())
      .map(value => value: String)
    override val field: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => value: String)
    override val operator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operator())
      .map(value => value: String)
    override val operand: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operand())
      .map(value => value: String)
    override val `then`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`then`())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val elseValue
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elseValue())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val operandType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operandType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ): zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    new Wrapper(impl)
}
