package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FileUploaderFieldConfig(
    accessLevel: zio.aws.amplifyuibuilder.model.StorageAccessLevel,
    acceptedFileTypes: Iterable[String],
    showThumbnails: Optional[Boolean] = Optional.Absent,
    isResumable: Optional[Boolean] = Optional.Absent,
    maxFileCount: Optional[Integer] = Optional.Absent,
    maxSize: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FileUploaderFieldConfig = {
    import FileUploaderFieldConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FileUploaderFieldConfig
      .builder()
      .accessLevel(accessLevel.unwrap)
      .acceptedFileTypes(acceptedFileTypes.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(showThumbnails.map(value => value: java.lang.Boolean))(
        _.showThumbnails
      )
      .optionallyWith(isResumable.map(value => value: java.lang.Boolean))(
        _.isResumable
      )
      .optionallyWith(maxFileCount.map(value => value: java.lang.Integer))(
        _.maxFileCount
      )
      .optionallyWith(maxSize.map(value => value: java.lang.Integer))(_.maxSize)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.wrap(buildAwsValue())
}
object FileUploaderFieldConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FileUploaderFieldConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig =
      zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig(
        accessLevel,
        acceptedFileTypes,
        showThumbnails.map(value => value),
        isResumable.map(value => value),
        maxFileCount.map(value => value),
        maxSize.map(value => value)
      )
    def accessLevel: zio.aws.amplifyuibuilder.model.StorageAccessLevel
    def acceptedFileTypes: List[String]
    def showThumbnails: Optional[Boolean]
    def isResumable: Optional[Boolean]
    def maxFileCount: Optional[Integer]
    def maxSize: Optional[Integer]
    def getAccessLevel
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.StorageAccessLevel] =
      ZIO.succeed(accessLevel)
    def getAcceptedFileTypes: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(acceptedFileTypes)
    def getShowThumbnails: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showThumbnails", showThumbnails)
    def getIsResumable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isResumable", isResumable)
    def getMaxFileCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxFileCount", maxFileCount)
    def getMaxSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSize", maxSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FileUploaderFieldConfig
  ) extends zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly {
    override val accessLevel
        : zio.aws.amplifyuibuilder.model.StorageAccessLevel =
      zio.aws.amplifyuibuilder.model.StorageAccessLevel.wrap(impl.accessLevel())
    override val acceptedFileTypes: List[String] = impl
      .acceptedFileTypes()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val showThumbnails: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.showThumbnails())
      .map(value => value: Boolean)
    override val isResumable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isResumable())
      .map(value => value: Boolean)
    override val maxFileCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileCount())
      .map(value => value: Integer)
    override val maxSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FileUploaderFieldConfig
  ): zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly =
    new Wrapper(impl)
}
