package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartCodegenJobRequest(
    appId: AppId,
    environmentName: String,
    clientToken: Optional[String] = Optional.Absent,
    codegenJobToCreate: zio.aws.amplifyuibuilder.model.StartCodegenJobData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest = {
    import StartCodegenJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .codegenJobToCreate(codegenJobToCreate.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.StartCodegenJobRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.StartCodegenJobRequest.wrap(buildAwsValue())
}
object StartCodegenJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.StartCodegenJobRequest =
      zio.aws.amplifyuibuilder.model.StartCodegenJobRequest(
        appId,
        environmentName,
        clientToken.map(value => value),
        codegenJobToCreate.asEditable
      )
    def appId: AppId
    def environmentName: String
    def clientToken: Optional[String]
    def codegenJobToCreate
        : zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCodegenJobToCreate: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly
    ] = ZIO.succeed(codegenJobToCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest
  ) extends zio.aws.amplifyuibuilder.model.StartCodegenJobRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplifyuibuilder.model.primitives.AppId(impl.appId())
    override val environmentName: String = impl.environmentName(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val codegenJobToCreate
        : zio.aws.amplifyuibuilder.model.StartCodegenJobData.ReadOnly =
      zio.aws.amplifyuibuilder.model.StartCodegenJobData
        .wrap(impl.codegenJobToCreate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest
  ): zio.aws.amplifyuibuilder.model.StartCodegenJobRequest.ReadOnly =
    new Wrapper(impl)
}
