package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters.*
sealed trait LabelDecorator {
  def unwrap
      : software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator
}
object LabelDecorator {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator
  ): zio.aws.amplifyuibuilder.model.LabelDecorator = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.REQUIRED =>
      val r = required
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.OPTIONAL =>
      val r = optional
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.LabelDecorator {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator =
      software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.UNKNOWN_TO_SDK_VERSION
  }
  case object required extends zio.aws.amplifyuibuilder.model.LabelDecorator {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator =
      software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.REQUIRED
  }
  case object optional extends zio.aws.amplifyuibuilder.model.LabelDecorator {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator =
      software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.OPTIONAL
  }
  case object none extends zio.aws.amplifyuibuilder.model.LabelDecorator {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator =
      software.amazon.awssdk.services.amplifyuibuilder.model.LabelDecorator.NONE
  }
}
