package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteThemeRequest(
    appId: String,
    environmentName: String,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest = {
    import DeleteThemeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.DeleteThemeRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.DeleteThemeRequest.wrap(buildAwsValue())
}
object DeleteThemeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.DeleteThemeRequest =
      zio.aws.amplifyuibuilder.model
        .DeleteThemeRequest(appId, environmentName, id)
    def appId: String
    def environmentName: String
    def id: Uuid
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest
  ) extends zio.aws.amplifyuibuilder.model.DeleteThemeRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest
  ): zio.aws.amplifyuibuilder.model.DeleteThemeRequest.ReadOnly = new Wrapper(
    impl
  )
}
