package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CodegenJobGenericDataSchema(
    dataSourceType: zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType,
    models: Map[String, zio.aws.amplifyuibuilder.model.CodegenGenericDataModel],
    enums: Map[String, zio.aws.amplifyuibuilder.model.CodegenGenericDataEnum],
    nonModels: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataNonModel
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema = {
    import CodegenJobGenericDataSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema
      .builder()
      .dataSourceType(dataSourceType.unwrap)
      .models(
        models
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .enums(
        enums
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .nonModels(
        nonModels
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema
      .wrap(buildAwsValue())
}
object CodegenJobGenericDataSchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema =
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema(
        dataSourceType,
        models.map({ case (key, value) =>
          key -> value.asEditable
        }),
        enums.map({ case (key, value) =>
          key -> value.asEditable
        }),
        nonModels.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def dataSourceType
        : zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType
    def models: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly
    ]
    def enums: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataEnum.ReadOnly
    ]
    def nonModels: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataNonModel.ReadOnly
    ]
    def getDataSourceType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType
    ] = ZIO.succeed(dataSourceType)
    def getModels: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly
    ]] = ZIO.succeed(models)
    def getEnums: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataEnum.ReadOnly
    ]] = ZIO.succeed(enums)
    def getNonModels: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataNonModel.ReadOnly
    ]] = ZIO.succeed(nonModels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema
  ) extends zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly {
    override val dataSourceType
        : zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType =
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSourceType
        .wrap(impl.dataSourceType())
    override val models: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly
    ] = impl
      .models()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.CodegenGenericDataModel
          .wrap(value)
      })
      .toMap
    override val enums: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataEnum.ReadOnly
    ] = impl
      .enums()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.CodegenGenericDataEnum
          .wrap(value)
      })
      .toMap
    override val nonModels: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataNonModel.ReadOnly
    ] = impl
      .nonModels()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.CodegenGenericDataNonModel
          .wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema
  ): zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly =
    new Wrapper(impl)
}
