package zio.aws.amplifyuibuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.{
  SyntheticTimestamp_date_time,
  TagValue,
  Uuid,
  AppId,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CodegenJob(
    id: Uuid,
    appId: AppId,
    environmentName: String,
    renderConfig: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig
    ] = Optional.Absent,
    genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema
    ] = Optional.Absent,
    autoGenerateForms: Optional[Boolean] = Optional.Absent,
    features: Optional[zio.aws.amplifyuibuilder.model.CodegenFeatureFlags] =
      Optional.Absent,
    status: Optional[zio.aws.amplifyuibuilder.model.CodegenJobStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    asset: Optional[zio.aws.amplifyuibuilder.model.CodegenJobAsset] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    modifiedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJob = {
    import CodegenJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJob
      .builder()
      .id(Uuid.unwrap(id): java.lang.String)
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(renderConfig.map(value => value.buildAwsValue()))(
        _.renderConfig
      )
      .optionallyWith(genericDataSchema.map(value => value.buildAwsValue()))(
        _.genericDataSchema
      )
      .optionallyWith(autoGenerateForms.map(value => value: java.lang.Boolean))(
        _.autoGenerateForms
      )
      .optionallyWith(features.map(value => value.buildAwsValue()))(_.features)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(asset.map(value => value.buildAwsValue()))(_.asset)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenJob.wrap(buildAwsValue())
}
object CodegenJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenJob =
      zio.aws.amplifyuibuilder.model.CodegenJob(
        id,
        appId,
        environmentName,
        renderConfig.map(value => value.asEditable),
        genericDataSchema.map(value => value.asEditable),
        autoGenerateForms.map(value => value),
        features.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value),
        asset.map(value => value.asEditable),
        tags.map(value => value),
        createdAt.map(value => value),
        modifiedAt.map(value => value)
      )
    def id: Uuid
    def appId: AppId
    def environmentName: String
    def renderConfig: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly
    ]
    def genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ]
    def autoGenerateForms: Optional[Boolean]
    def features
        : Optional[zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly]
    def status: Optional[zio.aws.amplifyuibuilder.model.CodegenJobStatus]
    def statusMessage: Optional[String]
    def asset: Optional[zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def modifiedAt: Optional[SyntheticTimestamp_date_time]
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getRenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("renderConfig", renderConfig)
    def getGenericDataSchema: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ] = AwsError.unwrapOptionField("genericDataSchema", genericDataSchema)
    def getAutoGenerateForms: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGenerateForms", autoGenerateForms)
    def getFeatures: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly
    ] = AwsError.unwrapOptionField("features", features)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.CodegenJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAsset: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly
    ] = AwsError.unwrapOptionField("asset", asset)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJob
  ) extends zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly {
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val appId: AppId =
      zio.aws.amplifyuibuilder.model.primitives.AppId(impl.appId())
    override val environmentName: String = impl.environmentName(): String
    override val renderConfig: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.renderConfig())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.wrap(value)
      )
    override val genericDataSchema: Optional[
      zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.genericDataSchema())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenJobGenericDataSchema.wrap(value)
      )
    override val autoGenerateForms: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGenerateForms())
      .map(value => value: Boolean)
    override val features: Optional[
      zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.features())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenFeatureFlags.wrap(value)
      )
    override val status
        : Optional[zio.aws.amplifyuibuilder.model.CodegenJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.amplifyuibuilder.model.CodegenJobStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val asset
        : Optional[zio.aws.amplifyuibuilder.model.CodegenJobAsset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.asset())
        .map(value =>
          zio.aws.amplifyuibuilder.model.CodegenJobAsset.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val modifiedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedAt())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJob
  ): zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly = new Wrapper(impl)
}
