package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentType,
  ComponentName,
  Uuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComponentData(
    id: Optional[Uuid] = Optional.Absent,
    name: Optional[ComponentName] = Optional.Absent,
    sourceId: Optional[String] = Optional.Absent,
    componentType: Optional[ComponentType] = Optional.Absent,
    properties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty]
    ] = Optional.Absent,
    children: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]
    ] = Optional.Absent,
    variants: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.ComponentVariant]
    ] = Optional.Absent,
    overrides: Optional[Map[String, Map[String, String]]] = Optional.Absent,
    bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
    ]] = Optional.Absent,
    collectionProperties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
    ] = Optional.Absent,
    events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent]
    ] = Optional.Absent,
    schemaVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData = {
    import UpdateComponentData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
      .builder()
      .optionallyWith(id.map(value => Uuid.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .optionallyWith(
        componentType.map(value =>
          ComponentType.unwrap(value): java.lang.String
        )
      )(_.componentType)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(
        variants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variants)
      .optionallyWith(
        overrides.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.overrides)
      .optionallyWith(
        bindingProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.bindingProperties)
      .optionallyWith(
        collectionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.collectionProperties)
      .optionallyWith(
        events.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.events)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateComponentData.wrap(buildAwsValue())
}
object UpdateComponentData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateComponentData =
      zio.aws.amplifyuibuilder.model.UpdateComponentData(
        id.map(value => value),
        name.map(value => value),
        sourceId.map(value => value),
        componentType.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        variants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        overrides.map(value => value),
        bindingProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        collectionProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        events.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        schemaVersion.map(value => value)
      )
    def id: Optional[Uuid]
    def name: Optional[ComponentName]
    def sourceId: Optional[String]
    def componentType: Optional[ComponentType]
    def properties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ]
    def children
        : Optional[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def variants: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    ]
    def overrides: Optional[Map[String, Map[String, String]]]
    def bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]]
    def collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]]
    def events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ]
    def schemaVersion: Optional[String]
    def getId: ZIO[Any, AwsError, Uuid] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getComponentType: ZIO[Any, AwsError, ComponentType] =
      AwsError.unwrapOptionField("componentType", componentType)
    def getProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getVariants: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly
    ]] = AwsError.unwrapOptionField("variants", variants)
    def getOverrides: ZIO[Any, AwsError, Map[String, Map[String, String]]] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getBindingProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getCollectionProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("collectionProperties", collectionProperties)
    def getEvents: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getSchemaVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ) extends zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly {
    override val id: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.Uuid(value))
    override val name: Optional[ComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ComponentName(value)
      )
    override val sourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => value: String)
    override val componentType: Optional[ComponentType] = zio.aws.core.internal
      .optionalFromNullable(impl.componentType())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.ComponentType(value)
      )
    override val properties: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
              .wrap(value)
          })
          .toMap
      )
    override val children: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.children())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
        }.toList
      )
    override val variants: Optional[
      List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.variants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(item)
        }.toList
      )
    override val overrides: Optional[Map[String, Map[String, String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala
                .map({ case (key, value) =>
                  (key: String) -> (value: String)
                })
                .toMap
            })
            .toMap
        )
    override val bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.bindingProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
              .wrap(value)
          })
          .toMap
      )
    override val collectionProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val events: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentEvent
              .wrap(value)
          })
          .toMap
      )
    override val schemaVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData
  ): zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly = new Wrapper(
    impl
  )
}
