package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThemeValue(
    value: Optional[String] = Optional.Absent,
    children: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue = {
    import ThemeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly =
    zio.aws.amplifyuibuilder.model.ThemeValue.wrap(buildAwsValue())
}
object ThemeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ThemeValue =
      zio.aws.amplifyuibuilder.model.ThemeValue(
        value.map(value => value),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def value: Optional[String]
    def children
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ) extends zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val children
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ): zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly = new Wrapper(impl)
}
