package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters.*
sealed trait FormDataSourceType {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType
}
object FormDataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType
  ): zio.aws.amplifyuibuilder.model.FormDataSourceType = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.DATA_STORE =>
      val r = DataStore
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.FormDataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType =
      software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DataStore
      extends zio.aws.amplifyuibuilder.model.FormDataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType =
      software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.DATA_STORE
  }
  case object Custom extends zio.aws.amplifyuibuilder.model.FormDataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType =
      software.amazon.awssdk.services.amplifyuibuilder.model.FormDataSourceType.CUSTOM
  }
}
