package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentType,
  ComponentName,
  Uuid
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ComponentSummary(
    appId: String,
    environmentName: String,
    id: Uuid,
    name: ComponentName,
    componentType: ComponentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary = {
    import ComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(ComponentName.unwrap(name): java.lang.String)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentSummary.wrap(buildAwsValue())
}
object ComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentSummary =
      zio.aws.amplifyuibuilder.model.ComponentSummary(
        appId,
        environmentName,
        id,
        name,
        componentType
      )
    def appId: String
    def environmentName: String
    def id: Uuid
    def name: ComponentName
    def componentType: ComponentType
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ComponentName] = ZIO.succeed(name)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ) extends zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName(impl.name())
    override val componentType: ComponentType =
      zio.aws.amplifyuibuilder.model.primitives
        .ComponentType(impl.componentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ): zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly = new Wrapper(
    impl
  )
}
