package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ValueMappings(
    values: Iterable[zio.aws.amplifyuibuilder.model.ValueMapping],
    bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings = {
    import ValueMappings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
      .builder()
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        bindingProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.bindingProperties)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly =
    zio.aws.amplifyuibuilder.model.ValueMappings.wrap(buildAwsValue())
}
object ValueMappings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ValueMappings =
      zio.aws.amplifyuibuilder.model.ValueMappings(
        values.map { item =>
          item.asEditable
        },
        bindingProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def values: List[zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly]
    def bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue.ReadOnly
    ]]
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly
    ]] = ZIO.succeed(values)
    def getBindingProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue.ReadOnly
    ]] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ) extends zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly {
    override val values
        : List[zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ValueMapping.wrap(item)
      }
      .toList
    override val bindingProperties: Optional[Map[
      String,
      zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.bindingProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ): zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly = new Wrapper(impl)
}
