package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.OperandType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Predicate(
    or: Optional[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] =
      Optional.Absent,
    and: Optional[Iterable[zio.aws.amplifyuibuilder.model.Predicate]] =
      Optional.Absent,
    field: Optional[String] = Optional.Absent,
    operator: Optional[String] = Optional.Absent,
    operand: Optional[String] = Optional.Absent,
    operandType: Optional[OperandType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Predicate = {
    import Predicate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
      .builder()
      .optionallyWith(
        or.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.or)
      .optionallyWith(
        and.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.and)
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(operand.map(value => value: java.lang.String))(_.operand)
      .optionallyWith(
        operandType.map(value => OperandType.unwrap(value): java.lang.String)
      )(_.operandType)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Predicate.ReadOnly =
    zio.aws.amplifyuibuilder.model.Predicate.wrap(buildAwsValue())
}
object Predicate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Predicate =
      zio.aws.amplifyuibuilder.model.Predicate(
        or.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        and.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        field.map(value => value),
        operator.map(value => value),
        operand.map(value => value),
        operandType.map(value => value)
      )
    def or: Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def and: Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]]
    def field: Optional[String]
    def operator: Optional[String]
    def operand: Optional[String]
    def operandType: Optional[OperandType]
    def getOr: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("or", or)
    def getAnd: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ]] = AwsError.unwrapOptionField("and", and)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getOperand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operand", operand)
    def getOperandType: ZIO[Any, AwsError, OperandType] =
      AwsError.unwrapOptionField("operandType", operandType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ) extends zio.aws.amplifyuibuilder.model.Predicate.ReadOnly {
    override val or
        : Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.or())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
    override val and
        : Optional[List[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.Predicate.wrap(item)
          }.toList
        )
    override val field: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => value: String)
    override val operator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operator())
      .map(value => value: String)
    override val operand: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operand())
      .map(value => value: String)
    override val operandType: Optional[OperandType] = zio.aws.core.internal
      .optionalFromNullable(impl.operandType())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives.OperandType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Predicate
  ): zio.aws.amplifyuibuilder.model.Predicate.ReadOnly = new Wrapper(impl)
}
