package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodegenJobRenderConfig(
    react: Optional[zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig = {
    import CodegenJobRenderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig
      .builder()
      .optionallyWith(react.map(value => value.buildAwsValue()))(_.react)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.wrap(buildAwsValue())
}
object CodegenJobRenderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig =
      zio.aws.amplifyuibuilder.model
        .CodegenJobRenderConfig(react.map(value => value.asEditable))
    def react: Optional[
      zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly
    ]
    def getReact: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly
    ] = AwsError.unwrapOptionField("react", react)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig
  ) extends zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly {
    override val react: Optional[
      zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.react())
      .map(value =>
        zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig
  ): zio.aws.amplifyuibuilder.model.CodegenJobRenderConfig.ReadOnly =
    new Wrapper(impl)
}
