package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{ThemeName, Uuid}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ThemeSummary(
    appId: String,
    environmentName: String,
    id: Uuid,
    name: ThemeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary = {
    import ThemeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(ThemeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly =
    zio.aws.amplifyuibuilder.model.ThemeSummary.wrap(buildAwsValue())
}
object ThemeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ThemeSummary =
      zio.aws.amplifyuibuilder.model.ThemeSummary(
        appId,
        environmentName,
        id,
        name
      )
    def appId: String
    def environmentName: String
    def id: Uuid
    def name: ThemeName
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ThemeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary
  ) extends zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: ThemeName =
      zio.aws.amplifyuibuilder.model.primitives.ThemeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary
  ): zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly = new Wrapper(impl)
}
