package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SectionalElement(
    level: Optional[Integer] = Optional.Absent,
    orientation: Optional[String] = Optional.Absent,
    position: Optional[zio.aws.amplifyuibuilder.model.FieldPosition] =
      Optional.Absent,
    text: Optional[String] = Optional.Absent,
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement = {
    import SectionalElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
      .builder()
      .optionallyWith(level.map(value => value: java.lang.Integer))(_.level)
      .optionallyWith(orientation.map(value => value: java.lang.String))(
        _.orientation
      )
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly =
    zio.aws.amplifyuibuilder.model.SectionalElement.wrap(buildAwsValue())
}
object SectionalElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.SectionalElement =
      zio.aws.amplifyuibuilder.model.SectionalElement(
        level.map(value => value),
        orientation.map(value => value),
        position.map(value => value.asEditable),
        text.map(value => value),
        `type`
      )
    def level: Optional[Integer]
    def orientation: Optional[String]
    def position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly]
    def text: Optional[String]
    def `type`: String
    def getLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("level", level)
    def getOrientation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("orientation", orientation)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly
    ] = AwsError.unwrapOptionField("position", position)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ) extends zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly {
    override val level: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.level())
      .map(value => value: Integer)
    override val orientation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.orientation())
      .map(value => value: String)
    override val position
        : Optional[zio.aws.amplifyuibuilder.model.FieldPosition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.amplifyuibuilder.model.FieldPosition.wrap(value))
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.SectionalElement
  ): zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly = new Wrapper(
    impl
  )
}
