package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey, ThemeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThemeData(
    name: ThemeName,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues],
    overrides: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData = {
    import CreateThemeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
      .builder()
      .name(ThemeName.unwrap(name): java.lang.String)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateThemeData.wrap(buildAwsValue())
}
object CreateThemeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateThemeData =
      zio.aws.amplifyuibuilder.model.CreateThemeData(
        name,
        values.map { item =>
          item.asEditable
        },
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def name: ThemeName
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ThemeName] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ) extends zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly {
    override val name: ThemeName =
      zio.aws.amplifyuibuilder.model.primitives.ThemeName(impl.name())
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
    override val overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ): zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly = new Wrapper(impl)
}
