package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ValueMappings(
    values: Iterable[zio.aws.amplifyuibuilder.model.ValueMapping]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings = {
    import ValueMappings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
      .builder()
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly =
    zio.aws.amplifyuibuilder.model.ValueMappings.wrap(buildAwsValue())
}
object ValueMappings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ValueMappings =
      zio.aws.amplifyuibuilder.model.ValueMappings(values.map { item =>
        item.asEditable
      })
    def values: List[zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly]
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly
    ]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ) extends zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly {
    override val values
        : List[zio.aws.amplifyuibuilder.model.ValueMapping.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ValueMapping.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappings
  ): zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly = new Wrapper(impl)
}
