package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFormResponse(
    form: Optional[zio.aws.amplifyuibuilder.model.Form] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse = {
    import GetFormResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse
      .builder()
      .optionallyWith(form.map(value => value.buildAwsValue()))(_.form)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetFormResponse.wrap(buildAwsValue())
}
object GetFormResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetFormResponse =
      zio.aws.amplifyuibuilder.model
        .GetFormResponse(form.map(value => value.asEditable))
    def form: Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly]
    def getForm
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      AwsError.unwrapOptionField("form", form)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse
  ) extends zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly {
    override val form: Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.form())
        .map(value => zio.aws.amplifyuibuilder.model.Form.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse
  ): zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly = new Wrapper(impl)
}
