package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComponentRequest(
    appId: String,
    clientToken: Optional[String] = Optional.Absent,
    environmentName: String,
    id: Uuid,
    updatedComponent: zio.aws.amplifyuibuilder.model.UpdateComponentData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest = {
    import UpdateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .updatedComponent(updatedComponent.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.UpdateComponentRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateComponentRequest.wrap(buildAwsValue())
}
object UpdateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateComponentRequest =
      zio.aws.amplifyuibuilder.model.UpdateComponentRequest(
        appId,
        clientToken.map(value => value),
        environmentName,
        id,
        updatedComponent.asEditable
      )
    def appId: String
    def clientToken: Optional[String]
    def environmentName: String
    def id: Uuid
    def updatedComponent
        : zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getUpdatedComponent: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly
    ] = ZIO.succeed(updatedComponent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest
  ) extends zio.aws.amplifyuibuilder.model.UpdateComponentRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val updatedComponent
        : zio.aws.amplifyuibuilder.model.UpdateComponentData.ReadOnly =
      zio.aws.amplifyuibuilder.model.UpdateComponentData
        .wrap(impl.updatedComponent())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest
  ): zio.aws.amplifyuibuilder.model.UpdateComponentRequest.ReadOnly =
    new Wrapper(impl)
}
