package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  TagValue,
  TagKey,
  FormName,
  Uuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Form(
    appId: String,
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig,
    environmentName: String,
    fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig],
    formActionType: zio.aws.amplifyuibuilder.model.FormActionType,
    id: Uuid,
    name: FormName,
    schemaVersion: String,
    sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement
    ],
    style: zio.aws.amplifyuibuilder.model.FormStyle,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Form = {
    import Form.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Form
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .dataType(dataType.buildAwsValue())
      .environmentName(environmentName: java.lang.String)
      .fields(
        fields
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .formActionType(formActionType.unwrap)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(FormName.unwrap(name): java.lang.String)
      .schemaVersion(schemaVersion: java.lang.String)
      .sectionalElements(
        sectionalElements
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .style(style.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Form.ReadOnly =
    zio.aws.amplifyuibuilder.model.Form.wrap(buildAwsValue())
}
object Form {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Form =
      zio.aws.amplifyuibuilder.model.Form(
        appId,
        cta.map(value => value.asEditable),
        dataType.asEditable,
        environmentName,
        fields.map({ case (key, value) =>
          key -> value.asEditable
        }),
        formActionType,
        id,
        name,
        schemaVersion,
        sectionalElements.map({ case (key, value) =>
          key -> value.asEditable
        }),
        style.asEditable,
        tags.map(value => value)
      )
    def appId: String
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    def environmentName: String
    def fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    def formActionType: zio.aws.amplifyuibuilder.model.FormActionType
    def id: Uuid
    def name: FormName
    def schemaVersion: String
    def sectionalElements
        : Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    def style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = ZIO.succeed(dataType)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getFields: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = ZIO.succeed(fields)
    def getFormActionType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormActionType] =
      ZIO.succeed(formActionType)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, FormName] = ZIO.succeed(name)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getSectionalElements: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = ZIO.succeed(sectionalElements)
    def getStyle
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      ZIO.succeed(style)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ) extends zio.aws.amplifyuibuilder.model.Form.ReadOnly {
    override val appId: String = impl.appId(): String
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val dataType
        : zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(impl.dataType())
    override val environmentName: String = impl.environmentName(): String
    override val fields
        : Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly] =
      impl
        .fields()
        .asScala
        .map({ case (key, value) =>
          (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
            .wrap(value)
        })
        .toMap
    override val formActionType: zio.aws.amplifyuibuilder.model.FormActionType =
      zio.aws.amplifyuibuilder.model.FormActionType.wrap(impl.formActionType())
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: FormName =
      zio.aws.amplifyuibuilder.model.primitives.FormName(impl.name())
    override val schemaVersion: String = impl.schemaVersion(): String
    override val sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ] = impl
      .sectionalElements()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
          .wrap(value)
      })
      .toMap
    override val style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormStyle.wrap(impl.style())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Form
  ): zio.aws.amplifyuibuilder.model.Form.ReadOnly = new Wrapper(impl)
}
