package zio.aws.amplifyuibuilder
import zio.aws.amplifyuibuilder.model.GetMetadataResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.amplifyuibuilder.model.{
  ListThemesRequest,
  ExportThemesRequest,
  UpdateFormRequest,
  ExportComponentsRequest,
  DeleteComponentRequest,
  DeleteFormRequest,
  PutMetadataFlagRequest,
  CreateComponentRequest,
  ExportFormsRequest,
  RefreshTokenRequest,
  GetThemeRequest,
  DeleteThemeRequest,
  ListFormsRequest,
  GetMetadataRequest,
  ExchangeCodeForTokenRequest,
  UpdateComponentRequest,
  ListComponentsRequest,
  CreateThemeRequest,
  UpdateThemeRequest,
  GetComponentRequest,
  GetFormRequest,
  CreateFormRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient
import zio.stream.ZStream
object AmplifyUiBuilderMock extends Mock[AmplifyUiBuilder] {
  object GetMetadata extends Effect[GetMetadataRequest, AwsError, ReadOnly]
  object ExportThemes
      extends Stream[
        ExportThemesRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.Theme.ReadOnly
      ]
  object ExportThemesPaginated
      extends Effect[
        ExportThemesRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
      ]
  object PutMetadataFlag extends Effect[PutMetadataFlagRequest, AwsError, Unit]
  object ExportComponents
      extends Stream[
        ExportComponentsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.Component.ReadOnly
      ]
  object ExportComponentsPaginated
      extends Effect[
        ExportComponentsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
      ]
  object DeleteTheme extends Effect[DeleteThemeRequest, AwsError, Unit]
  object CreateTheme
      extends Effect[
        CreateThemeRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly
      ]
  object ListThemes
      extends Stream[
        ListThemesRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
      ]
  object ListThemesPaginated
      extends Effect[
        ListThemesRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
      ]
  object GetForm
      extends Effect[
        GetFormRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly
      ]
  object ExportForms
      extends Stream[
        ExportFormsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.Form.ReadOnly
      ]
  object ExportFormsPaginated
      extends Effect[
        ExportFormsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly
      ]
  object ListForms
      extends Stream[
        ListFormsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly
      ]
  object ListFormsPaginated
      extends Effect[
        ListFormsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly
      ]
  object ListComponents
      extends Stream[
        ListComponentsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
      ]
  object ListComponentsPaginated
      extends Effect[
        ListComponentsRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
      ]
  object RefreshToken
      extends Effect[
        RefreshTokenRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
      ]
  object UpdateForm
      extends Effect[
        UpdateFormRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly
      ]
  object GetTheme
      extends Effect[
        GetThemeRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly
      ]
  object CreateForm
      extends Effect[
        CreateFormRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly
      ]
  object DeleteComponent extends Effect[DeleteComponentRequest, AwsError, Unit]
  object DeleteForm extends Effect[DeleteFormRequest, AwsError, Unit]
  object CreateComponent
      extends Effect[
        CreateComponentRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
      ]
  object ExchangeCodeForToken
      extends Effect[
        ExchangeCodeForTokenRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
      ]
  object GetComponent
      extends Effect[
        GetComponentRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
      ]
  object UpdateComponent
      extends Effect[
        UpdateComponentRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
      ]
  object UpdateTheme
      extends Effect[
        UpdateThemeRequest,
        AwsError,
        zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AmplifyUiBuilder] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AmplifyUiBuilder] { rts =>
        zio.ZIO.succeed {
          new AmplifyUiBuilder {
            val api: AmplifyUiBuilderAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AmplifyUiBuilder = this
            def getMetadata(
                request: GetMetadataRequest
            ): IO[AwsError, ReadOnly] = proxy(GetMetadata, request)
            def exportThemes(request: ExportThemesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.Theme.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ExportThemes, request)
                }
                .getOrThrowFiberFailure()
            }
            def exportThemesPaginated(request: ExportThemesRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
            ] = proxy(ExportThemesPaginated, request)
            def putMetadataFlag(
                request: PutMetadataFlagRequest
            ): IO[AwsError, Unit] = proxy(PutMetadataFlag, request)
            def exportComponents(request: ExportComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.Component.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ExportComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def exportComponentsPaginated(request: ExportComponentsRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
            ] = proxy(ExportComponentsPaginated, request)
            def deleteTheme(request: DeleteThemeRequest): IO[AwsError, Unit] =
              proxy(DeleteTheme, request)
            def createTheme(request: CreateThemeRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly
            ] = proxy(CreateTheme, request)
            def listThemes(request: ListThemesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListThemes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listThemesPaginated(request: ListThemesRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
            ] = proxy(ListThemesPaginated, request)
            def getForm(request: GetFormRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly
            ] = proxy(GetForm, request)
            def exportForms(request: ExportFormsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.Form.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ExportForms, request)
                }
                .getOrThrowFiberFailure()
            }
            def exportFormsPaginated(request: ExportFormsRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly
            ] = proxy(ExportFormsPaginated, request)
            def listForms(request: ListFormsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListForms, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFormsPaginated(request: ListFormsRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly
            ] = proxy(ListFormsPaginated, request)
            def listComponents(request: ListComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentsPaginated(request: ListComponentsRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
            ] = proxy(ListComponentsPaginated, request)
            def refreshToken(request: RefreshTokenRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
            ] = proxy(RefreshToken, request)
            def updateForm(request: UpdateFormRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly
            ] = proxy(UpdateForm, request)
            def getTheme(request: GetThemeRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly
            ] = proxy(GetTheme, request)
            def createForm(request: CreateFormRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly
            ] = proxy(CreateForm, request)
            def deleteComponent(
                request: DeleteComponentRequest
            ): IO[AwsError, Unit] = proxy(DeleteComponent, request)
            def deleteForm(request: DeleteFormRequest): IO[AwsError, Unit] =
              proxy(DeleteForm, request)
            def createComponent(request: CreateComponentRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
            ] = proxy(CreateComponent, request)
            def exchangeCodeForToken(request: ExchangeCodeForTokenRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
            ] = proxy(ExchangeCodeForToken, request)
            def getComponent(request: GetComponentRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
            ] = proxy(GetComponent, request)
            def updateComponent(request: UpdateComponentRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
            ] = proxy(UpdateComponent, request)
            def updateTheme(request: UpdateThemeRequest): IO[
              AwsError,
              zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
            ] = proxy(UpdateTheme, request)
          }
        }
      }
    }
  }
}
