package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutMetadataFlagRequest(
    appId: String,
    body: zio.aws.amplifyuibuilder.model.PutMetadataFlagBody,
    environmentName: String,
    featureName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest = {
    import PutMetadataFlagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest
      .builder()
      .appId(appId: java.lang.String)
      .body(body.buildAwsValue())
      .environmentName(environmentName: java.lang.String)
      .featureName(featureName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest.wrap(buildAwsValue())
}
object PutMetadataFlagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest =
      zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest(
        appId,
        body.asEditable,
        environmentName,
        featureName
      )
    def appId: String
    def body: zio.aws.amplifyuibuilder.model.PutMetadataFlagBody.ReadOnly
    def environmentName: String
    def featureName: String
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getBody: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.PutMetadataFlagBody.ReadOnly
    ] = ZIO.succeed(body)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getFeatureName: ZIO[Any, Nothing, String] = ZIO.succeed(featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest
  ) extends zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val body
        : zio.aws.amplifyuibuilder.model.PutMetadataFlagBody.ReadOnly =
      zio.aws.amplifyuibuilder.model.PutMetadataFlagBody.wrap(impl.body())
    override val environmentName: String = impl.environmentName(): String
    override val featureName: String = impl.featureName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest
  ): zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest.ReadOnly =
    new Wrapper(impl)
}
