package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFormResponse(
    entity: Optional[zio.aws.amplifyuibuilder.model.Form] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse = {
    import UpdateFormResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse
      .builder()
      .optionallyWith(entity.map(value => value.buildAwsValue()))(_.entity)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateFormResponse.wrap(buildAwsValue())
}
object UpdateFormResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateFormResponse =
      zio.aws.amplifyuibuilder.model
        .UpdateFormResponse(entity.map(value => value.asEditable))
    def entity: Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly]
    def getEntity
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      AwsError.unwrapOptionField("entity", entity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse
  ) extends zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly {
    override val entity
        : Optional[zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entity())
        .map(value => zio.aws.amplifyuibuilder.model.Form.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse
  ): zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly = new Wrapper(
    impl
  )
}
