package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateThemeResponse(
    entity: Optional[zio.aws.amplifyuibuilder.model.Theme] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse = {
    import UpdateThemeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse
      .builder()
      .optionallyWith(entity.map(value => value.buildAwsValue()))(_.entity)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateThemeResponse.wrap(buildAwsValue())
}
object UpdateThemeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateThemeResponse =
      zio.aws.amplifyuibuilder.model
        .UpdateThemeResponse(entity.map(value => value.asEditable))
    def entity: Optional[zio.aws.amplifyuibuilder.model.Theme.ReadOnly]
    def getEntity
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      AwsError.unwrapOptionField("entity", entity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse
  ) extends zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly {
    override val entity
        : Optional[zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entity())
        .map(value => zio.aws.amplifyuibuilder.model.Theme.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse
  ): zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly = new Wrapper(
    impl
  )
}
