package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetComponentRequest(
    appId: String,
    environmentName: String,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest = {
    import GetComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetComponentRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetComponentRequest.wrap(buildAwsValue())
}
object GetComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetComponentRequest =
      zio.aws.amplifyuibuilder.model
        .GetComponentRequest(appId, environmentName, id)
    def appId: String
    def environmentName: String
    def id: Uuid
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest
  ) extends zio.aws.amplifyuibuilder.model.GetComponentRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest
  ): zio.aws.amplifyuibuilder.model.GetComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
