package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FormInputValueProperty(
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty = {
    import FormInputValueProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormInputValueProperty.wrap(buildAwsValue())
}
object FormInputValueProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormInputValueProperty =
      zio.aws.amplifyuibuilder.model
        .FormInputValueProperty(value.map(value => value))
    def value: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ) extends zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ): zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly =
    new Wrapper(impl)
}
