package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportFormsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.Form],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse = {
    import ExportFormsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportFormsResponse.wrap(buildAwsValue())
}
object ExportFormsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportFormsResponse =
      zio.aws.amplifyuibuilder.model.ExportFormsResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.Form.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.Form.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse
  ) extends zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly {
    override val entities: List[zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      impl
        .entities()
        .asScala
        .map { item =>
          zio.aws.amplifyuibuilder.model.Form.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse
  ): zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly = new Wrapper(
    impl
  )
}
