package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThemeValue(
    children: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue = {
    import ThemeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
      .builder()
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly =
    zio.aws.amplifyuibuilder.model.ThemeValue.wrap(buildAwsValue())
}
object ThemeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ThemeValue =
      zio.aws.amplifyuibuilder.model.ThemeValue(
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        value.map(value => value)
      )
    def children
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def value: Optional[String]
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ) extends zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly {
    override val children
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValue
  ): zio.aws.amplifyuibuilder.model.ThemeValue.ReadOnly = new Wrapper(impl)
}
