package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey, FormName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFormData(
    cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA] = Optional.Absent,
    dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig,
    fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig],
    formActionType: zio.aws.amplifyuibuilder.model.FormActionType,
    name: FormName,
    schemaVersion: String,
    sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement
    ],
    style: zio.aws.amplifyuibuilder.model.FormStyle,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData = {
    import CreateFormData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
      .builder()
      .optionallyWith(cta.map(value => value.buildAwsValue()))(_.cta)
      .dataType(dataType.buildAwsValue())
      .fields(
        fields
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .formActionType(formActionType.unwrap)
      .name(FormName.unwrap(name): java.lang.String)
      .schemaVersion(schemaVersion: java.lang.String)
      .sectionalElements(
        sectionalElements
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .style(style.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateFormData.wrap(buildAwsValue())
}
object CreateFormData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateFormData =
      zio.aws.amplifyuibuilder.model.CreateFormData(
        cta.map(value => value.asEditable),
        dataType.asEditable,
        fields.map({ case (key, value) =>
          key -> value.asEditable
        }),
        formActionType,
        name,
        schemaVersion,
        sectionalElements.map({ case (key, value) =>
          key -> value.asEditable
        }),
        style.asEditable,
        tags.map(value => value)
      )
    def cta: Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly]
    def dataType: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    def fields: Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly]
    def formActionType: zio.aws.amplifyuibuilder.model.FormActionType
    def name: FormName
    def schemaVersion: String
    def sectionalElements
        : Map[String, zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly]
    def style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getCta
        : ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      AwsError.unwrapOptionField("cta", cta)
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly
    ] = ZIO.succeed(dataType)
    def getFields: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly
    ]] = ZIO.succeed(fields)
    def getFormActionType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormActionType] =
      ZIO.succeed(formActionType)
    def getName: ZIO[Any, Nothing, FormName] = ZIO.succeed(name)
    def getSchemaVersion: ZIO[Any, Nothing, String] = ZIO.succeed(schemaVersion)
    def getSectionalElements: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ]] = ZIO.succeed(sectionalElements)
    def getStyle
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly] =
      ZIO.succeed(style)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ) extends zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly {
    override val cta
        : Optional[zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cta())
        .map(value => zio.aws.amplifyuibuilder.model.FormCTA.wrap(value))
    override val dataType
        : zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(impl.dataType())
    override val fields
        : Map[String, zio.aws.amplifyuibuilder.model.FieldConfig.ReadOnly] =
      impl
        .fields()
        .asScala
        .map({ case (key, value) =>
          (key: String) -> zio.aws.amplifyuibuilder.model.FieldConfig
            .wrap(value)
        })
        .toMap
    override val formActionType: zio.aws.amplifyuibuilder.model.FormActionType =
      zio.aws.amplifyuibuilder.model.FormActionType.wrap(impl.formActionType())
    override val name: FormName =
      zio.aws.amplifyuibuilder.model.primitives.FormName(impl.name())
    override val schemaVersion: String = impl.schemaVersion(): String
    override val sectionalElements: Map[
      String,
      zio.aws.amplifyuibuilder.model.SectionalElement.ReadOnly
    ] = impl
      .sectionalElements()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.SectionalElement
          .wrap(value)
      })
      .toMap
    override val style: zio.aws.amplifyuibuilder.model.FormStyle.ReadOnly =
      zio.aws.amplifyuibuilder.model.FormStyle.wrap(impl.style())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormData
  ): zio.aws.amplifyuibuilder.model.CreateFormData.ReadOnly = new Wrapper(impl)
}
