package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentConditionProperty(
    elseValue: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    field: Optional[String] = Optional.Absent,
    operand: Optional[String] = Optional.Absent,
    operandType: Optional[String] = Optional.Absent,
    operator: Optional[String] = Optional.Absent,
    property: Optional[String] = Optional.Absent,
    `then`: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty = {
    import ComponentConditionProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
      .builder()
      .optionallyWith(elseValue.map(value => value.buildAwsValue()))(
        _.elseValue
      )
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(operand.map(value => value: java.lang.String))(_.operand)
      .optionallyWith(operandType.map(value => value: java.lang.String))(
        _.operandType
      )
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(property.map(value => value: java.lang.String))(
        _.property
      )
      .optionallyWith(`then`.map(value => value.buildAwsValue()))(_.`then`)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentConditionProperty
      .wrap(buildAwsValue())
}
object ComponentConditionProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentConditionProperty =
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty(
        elseValue.map(value => value.asEditable),
        field.map(value => value),
        operand.map(value => value),
        operandType.map(value => value),
        operator.map(value => value),
        property.map(value => value),
        `then`.map(value => value.asEditable)
      )
    def elseValue
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def field: Optional[String]
    def operand: Optional[String]
    def operandType: Optional[String]
    def operator: Optional[String]
    def property: Optional[String]
    def `then`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def getElseValue: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("elseValue", elseValue)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getOperand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operand", operand)
    def getOperandType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operandType", operandType)
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getProperty: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("property", property)
    def getThen: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("then", `then`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ) extends zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly {
    override val elseValue
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elseValue())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val field: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => value: String)
    override val operand: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operand())
      .map(value => value: String)
    override val operandType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operandType())
      .map(value => value: String)
    override val operator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operator())
      .map(value => value: String)
    override val property: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.property())
      .map(value => value: String)
    override val `then`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`then`())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ): zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    new Wrapper(impl)
}
