package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{TagValue, TagKey, ThemeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateThemeData(
    name: ThemeName,
    overrides: Optional[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData = {
    import CreateThemeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
      .builder()
      .name(ThemeName.unwrap(name): java.lang.String)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateThemeData.wrap(buildAwsValue())
}
object CreateThemeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateThemeData =
      zio.aws.amplifyuibuilder.model.CreateThemeData(
        name,
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        values.map { item =>
          item.asEditable
        }
      )
    def name: ThemeName
    def overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def getName: ZIO[Any, Nothing, ThemeName] = ZIO.succeed(name)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ) extends zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly {
    override val name: ThemeName =
      zio.aws.amplifyuibuilder.model.primitives.ThemeName(impl.name())
    override val overrides
        : Optional[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData
  ): zio.aws.amplifyuibuilder.model.CreateThemeData.ReadOnly = new Wrapper(impl)
}
