package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MutationActionSetStateParameter(
    componentName: String,
    property: String,
    set: zio.aws.amplifyuibuilder.model.ComponentProperty
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter = {
    import MutationActionSetStateParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter
      .builder()
      .componentName(componentName: java.lang.String)
      .property(property: java.lang.String)
      .set(set.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly =
    zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter
      .wrap(buildAwsValue())
}
object MutationActionSetStateParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter =
      zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter(
        componentName,
        property,
        set.asEditable
      )
    def componentName: String
    def property: String
    def set: zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    def getComponentName: ZIO[Any, Nothing, String] = ZIO.succeed(componentName)
    def getProperty: ZIO[Any, Nothing, String] = ZIO.succeed(property)
    def getSet: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = ZIO.succeed(set)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter
  ) extends zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly {
    override val componentName: String = impl.componentName(): String
    override val property: String = impl.property(): String
    override val set
        : zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly =
      zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(impl.set())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter
  ): zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly =
    new Wrapper(impl)
}
