package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.ComponentSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse = {
    import ListComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListComponentsResponse.wrap(buildAwsValue())
}
object ListComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListComponentsResponse =
      zio.aws.amplifyuibuilder.model.ListComponentsResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse
  ) extends zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ComponentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse
  ): zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly =
    new Wrapper(impl)
}
